/*
 * FixScript Task v0.2 - http://www.fixscript.org/
 * Copyright (c) 2020-2021 Martin Dvorak <jezek2@advel.cz>
 *
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the authors be held liable for any damages arising from
 * the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose, 
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 */

#ifndef FIXTASK_H
#define FIXTASK_H

#include "fixscript.h"

typedef Heap *(*HeapCreateFunc)(void *data);
typedef void (*ComputeHeapRunFunc)(Heap *heap, int idx, void *data);

void fixtask_register_functions(Heap *heap, HeapCreateFunc create_func, void *create_data, LoadScriptFunc load_func, void *load_data);

void fixtask_get_script_load_function(Heap *heap, LoadScriptFunc *load_func, void **load_data);
int fixtask_get_cores_count(Heap *heap);

void fixtask_run_on_compute_threads(Heap *heap, Value *error, ComputeHeapRunFunc func, void *data);

#endif /* FIXTASK_H */
